IF OBJECT_ID('UFD_EXP_CTB_MOV_PG_CRED_APROP') IS NOT NULL
	BEGIN
		DROP FUNCTION UFD_EXP_CTB_MOV_PG_CRED_APROP
	END
	
GO	
     
 
CREATE FUNCTION UFD_EXP_CTB_MOV_PG_CRED_APROP( @CD_EMP		INT,
											   @CD_FILIAL	INT,
											   @DT_INI		DATETIME,
											   @DT_FIM		DATETIME)		
RETURNS @RS_RETURN TABLE(
			CD_EMP					INT,
			CD_FILIAL				INT,
			RZ_FORN					VARCHAR(100),
			NR_CNT					VARCHAR(50),
			CNT_CENTRO_CTB			INT,			
			DT_EMIS					DATETIME, 
			CD_FORN					INT,
			HIST					VARCHAR(150),
			CD_DESP_REC				INT, 
			CD_CNT_CTB_RED			INT, 
			DS_DESP_REC				VARCHAR(150),
			RATEIO_CENTRO_CUSTO		INT, 
			VLR_RAT_DESP			MONEY,
			VLR_RAT_CENTRO_CUSTO	MONEY,
			DS_CENTRO_CTB			VARCHAR(100),
			NR_NF					INT,
			NM_FANT					VARCHAR(100),
			NR_DP					INT)					

AS
BEGIN       
	
	DECLARE @CD_GRP_ECON			INT
	
	SET @CD_GRP_ECON = (SELECT PRC_GRP_ECON_PRC_FILIAL.CD_GRP_ECON
						FROM PRC_FILIAL
							INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON
								PRC_FILIAL.CD_EMP = PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND 
								PRC_FILIAL.CD_FILIAL = PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL
						WHERE
						    PRC_FILIAL.CD_EMP = @CD_EMP
						    AND PRC_FILIAL.CD_FILIAL = @CD_FILIAL
						    AND PRC_FILIAL.FILIAL_MTZ_GRP_ECON = 1)
	
	IF ISNULL(@CD_GRP_ECON,0) = 0 
		BEGIN
			RETURN
		END
		
	INSERT INTO @RS_RETURN 
		SELECT DISTINCT 
			V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.CD_EMP,
			V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.CD_FILIAL,
			V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.RZ_FORN,
			V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.NR_CNT, 
			ISNULL(V_PG_DESP_RAT_CONTAS_CENTRO_CUSTO_PAGAR_CONTABIL.CNT_CENTRO_CTB,0) AS CNT_CENTRO_CTB,			
			V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.DT_CAD AS DT_EMIS, 
			V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.CD_FORN,
			V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.HIST,
			V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.CD_DESP_REC, 
			V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.CD_CNT_CTB_RED, 
			V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.DS_DESP_REC,
			V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.RATEIO_CENTRO_CUSTO, 
			V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.VLR_RAT_DESP,
			ISNULL(V_PG_DESP_RAT_CONTAS_CENTRO_CUSTO_PAGAR_CONTABIL.VLR_RAT_CENTRO_CUSTO,0) AS VLR_RAT_CENTRO_CUSTO,
			ISNULL(V_PG_DESP_RAT_CONTAS_CENTRO_CUSTO_PAGAR_CONTABIL.DS_CENTRO_CTB,'') AS DS_CENTRO_CTB,
			ISNULL(V_PG_DESP_RAT_CONTAS_CENTRO_CUSTO_PAGAR_CONTABIL.NR_NF,0) AS NR_NF,
			PRC_FILIAL.NM_FANT,
			V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.NR_DP
	    
		FROM V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL 
			LEFT OUTER JOIN V_PG_DESP_RAT_CONTAS_CENTRO_CUSTO_PAGAR_CONTABIL ON
				V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.CD_EMP = V_PG_DESP_RAT_CONTAS_CENTRO_CUSTO_PAGAR_CONTABIL.CD_EMP AND
				V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.CD_FILIAL = V_PG_DESP_RAT_CONTAS_CENTRO_CUSTO_PAGAR_CONTABIL.CD_FILIAL AND
				V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.DT_CAD = V_PG_DESP_RAT_CONTAS_CENTRO_CUSTO_PAGAR_CONTABIL.DT_CAD AND
				V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.CD_DESP_REC = V_PG_DESP_RAT_CONTAS_CENTRO_CUSTO_PAGAR_CONTABIL.CD_DESP_REC AND
				V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.NR_NF = V_PG_DESP_RAT_CONTAS_CENTRO_CUSTO_PAGAR_CONTABIL.NR_NF AND
				V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.CD_FORN = V_PG_DESP_RAT_CONTAS_CENTRO_CUSTO_PAGAR_CONTABIL.CD_FORN AND
				V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.NR_DP = V_PG_DESP_RAT_CONTAS_CENTRO_CUSTO_PAGAR_CONTABIL.NR_DP
		    
			INNER JOIN PRC_FILIAL ON
				V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.CD_EMP = PRC_FILIAL.CD_EMP AND
				V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.CD_FILIAL = PRC_FILIAL.CD_FILIAL
		    
		WHERE 
			V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.CD_EMP			= @CD_EMP
			AND V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.CD_FILIAL	IN	   (SELECT CD_FILIAL 
																		FROM PRC_GRP_ECON_PRC_FILIAL
																		WHERE CD_GRP_ECON = @CD_GRP_ECON)
			AND V_PG_DESP_RAT_CONTAS_PAGAR_CONTABIL.DT_CAD		BETWEEN @DT_INI AND @DT_FIM

		ORDER BY RZ_FORN,NR_DP,NR_NF

	RETURN
		
END		